"""Module for functions that convert files between formats."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = ['netcdf_to_text']

# 1. Standard Python modules
from pathlib import Path
import subprocess

# 2. Third party modules

# 3. Aquaveo modules
from xms.executables.ncdump import paths as ncdump_paths

# 4. Local modules


def netcdf_to_text(data_file: str | Path, out_file: str | Path):
    """
    Dump a NetCDF (or any H5 file) to a text file.

    The converter includes the file name in the first line of the output. This function overrides the file name to be
    "base" so the output only depends on the input file's contents, not its name.

    Args:
        data_file: Path to the NetCDF file.
        out_file: Path to the output text file.
    """
    ncdump_exe = ncdump_paths['ncdump.exe']
    arguments = [ncdump_exe, '-n', 'base', data_file]
    with open(out_file, 'w') as f:
        subprocess.run(arguments, stdout=f, check=True)
