"""Utility methods for handling column headers in pandas and the Qt GUI."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"


NULL_SELECTION = '(none selected)'


def change_df_column_names(df, direction):
    r"""Replaces special strings in the column names of the data.

    Args:
        df (DataFrame): the data frame
        direction (bool): If True, newline characters removed. If False, __new_line__ replaced with '\n'
    """
    idx = (0, 1) if direction else (1, 0)
    replace_strings = [('\n', '__new_line__'), ('/', '__slash__')]
    cols = df.columns
    new_cols = []
    for c in range(len(cols)):
        new_str = cols[c]
        for rep in replace_strings:
            new_str = new_str.replace(rep[idx[0]], rep[idx[1]])
        new_cols.append(new_str)
    df.columns = new_cols


def fix_df_column_names_for_gui(df):
    r"""Fix special header tokens for the GUI.

    We want multiline headers for some data frames for the gui but we don't want '\n' or
    the like in the files. So this method replaces special characters according to the dict

    Args:
        df (DataFrame): the data frame
    """
    change_df_column_names(df, False)


def fix_df_column_names_for_io(df):
    r"""Fix special header tokens for the I/O.

    We want multiline headers for some data frames for the gui but we don't want '\n' or
    the like in the files. So this method replaces special characters according to the dict

    Args:
        df (DataFrame): the data frame
    """
    change_df_column_names(df, True)
