"""RefineUGridByErrorTool class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.tool.ugrids.refine_ugrid_by_error_tool import RefineUGridByErrorTool

ARG_INPUT_GRID = 0
ARG_OUTPUT_GRID = 1
ARG_ERROR_THRESHOLD = 2
ARG_MAX_ITRS = 3
ARG_RASTER_1 = 4
ARG_RASTER_2 = 5

DEFAULT_TOLERANCE = 0.000001  # XM_ZERO_TOL


class RefineMeshByErrorTool(RefineUGridByErrorTool):
    """Tool to interpolate multiple rasters to a UGrid with priority."""

    def __init__(self):
        """Initializes the class."""
        super().__init__(name='Refine 2D Mesh by Error')
        self._force_ugrid = False
        self._geom_txt = 'mesh'
