"""D8FlowAccumulationTool whitebox tool class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.tool.whitebox import WhiteboxTool
from xms.tool.whitebox.whitebox_tool import get_argument_from_name


class D8FlowAccumulationTool(WhiteboxTool):
    """D8FlowAccumulationTool whitebox tool class."""

    def __init__(self):
        """Initializes the class."""
        super().__init__('D8FlowAccumulation')

    def validate_arguments(self, arguments):
        """Called to determine if arguments are valid.

        Args:
            arguments (list): The tool arguments.

        Returns:
            (dict): Dictionary of errors for arguments.
        """
        errors = {}
        is_flow_pointer = get_argument_from_name(arguments, 'is_the_input_raster_a_d8_flow_pointer').value
        uses_esri_scheme = get_argument_from_name(arguments,
                                                  'if_a_pointer_is_input,_does_it_use_the_esri_pointer_scheme').value
        if is_flow_pointer or uses_esri_scheme:
            raster = self.get_input_raster(get_argument_from_name(arguments, 'input_dem_or_d8_pointer_file').value)
            z_min, z_max = raster.get_z_min_max()
            if z_min < 0 or z_max > 128:
                errors['is_the_input_raster_a_d8_flow_pointer'] = 'The range of values in the input raster is not ' \
                                                                  'within the expected range of values (0-128) of a ' \
                                                                  'flow direction raster.  Please select a flow ' \
                                                                  'direction raster if specifying the option that ' \
                                                                  'the input raster is a flow pointer or that the ' \
                                                                  'input raster uses the ESRI style scheme.'
        return errors
