"""EdgePreservingMeanFilterTool whitebox tool class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.tool.whitebox import WhiteboxTool
from xms.tool.whitebox.whitebox_tool import get_argument_from_name


class EdgePreservingMeanFilterTool(WhiteboxTool):
    """EdgePreservingMeanFilterTool whitebox tool class."""

    def __init__(self):
        """Initializes the class."""
        super().__init__('EdgePreservingMeanFilter')

    def validate_arguments(self, arguments):
        """Called to determine if arguments are valid.

        Args:
            arguments (list): The tool arguments.

        Returns:
            (dict): Dictionary of errors for arguments.
        """
        errors = {}
        filter_size = get_argument_from_name(arguments, 'filter_size').value
        raster = self.get_input_raster(get_argument_from_name(arguments, 'input_file').value)
        num_rows, num_cols = raster.resolution
        num_pixels = min(num_cols, num_rows)
        if filter_size > num_pixels:
            errors['filter_size'] = f'The filter size of {filter_size} is larger than it should be. A filter size' \
                                    ' less than the number of pixels in the X or Y direction is recommended.'
        elif filter_size % 2 == 0:
            errors['filter_size'] = 'The filter size should be an odd number.'
        return errors
