"""Constants for BC GUI."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"


"""
Combobox option indices for BC types
"""
BC_TYPE_MONITOR = 0
# Arc BC types
BC_TYPE_HQ = 1
BC_TYPE_Q = 2
BC_TYPE_QN = 3
BC_TYPE_WL = 4
BC_TYPE_WLS = 5
BC_TYPE_WL_CURT = 6  # Curtain BCs stored with bcs, but use NetCDF files instead of curve CSVs
BC_TYPE_ZG = 7
# Point BC types
BC_TYPE_QC = 0
# Polygon BC types
BC_TYPE_QC_POLY = 0
# Global BC types. Stored on the simulation, not the coverage
BC_TYPE_QG = 0
# Gridded BC types. Stored on the simulation, not the coverage
BC_TYPE_MSLP = 0
BC_TYPE_W10 = 1
BC_TYPE_WAVE = 2

# Maximum number of subtypes for dynamic combobox
MAX_NUM_SUBTYPES = 6

# Combobox option indices for the global export combobox
GLOBAL_2DM_IDX = 0
GLOBAL_SHAPEFILE_IDX = 1

"""
BcSeriesEditor time conversion constants
"""
# Combobox indices of time units combobox
DAY_UNITS_IDX = 0
HOUR_UNITS_IDX = 1
MIN_UNITS_IDX = 2
SEC_UNITS_IDX = 3
ISODATE_UNITS_IDX = 4

UNIT_CONVERSIONS = {
    DAY_UNITS_IDX: {
        HOUR_UNITS_IDX: 24.0,
        MIN_UNITS_IDX: 24.0 * 60.0,
        SEC_UNITS_IDX: 24.0 * 60.0 * 60.0,
    },
    HOUR_UNITS_IDX: {
        DAY_UNITS_IDX: 1.0 / 24.0,
        MIN_UNITS_IDX: 60.0,
        SEC_UNITS_IDX: 60.0 * 60.0,
    },
    MIN_UNITS_IDX: {
        DAY_UNITS_IDX: 1.0 / (24.0 * 60.0),
        HOUR_UNITS_IDX: 1.0 / 60.0,
        SEC_UNITS_IDX: 60.0,
    },
    SEC_UNITS_IDX: {
        DAY_UNITS_IDX: 1.0 / (24.0 * 60.0 * 60.0),
        HOUR_UNITS_IDX: 1.0 / (60.0 * 60.0),
        MIN_UNITS_IDX: 1.0 / 60.0,
    }
}

"""
BC combobox option texts and user data
"""
BC_CBX_OPTS = {
    'cbx_bc_type': (
        ['Monitor', 'HQ (Head Discharge)', 'Q (Nodestring Flow)', 'QN (Head Discharge)', 'WL (Water Level)',
         'WLS (Sloping Water Level)', 'WL_CURT (Water Level Curtain)', 'ZG (Zero Gradient)'],  # Combobox option test
        ['Monitor', 'HQ', 'Q', 'QN', 'WL', 'WLS', 'WL_CURT', 'ZG'],  # User data
    ),
    'cbx_bc_subtype': (
        ['Sub-type 1', 'Sub-type 2', 'Sub-type 3', 'Sub-type 4', 'Sub-type 5', 'Sub-type 6'],
        [1, 2, 3, 4, 5, 6],
    ),
    'cbx_time_units': (
        ['Days', 'Hours', 'Minutes', 'Seconds', 'Isotime'],
        ['Days', 'Hours', 'Minutes', 'Seconds', 'Isotime'],
    ),
    'cbx_vertical_distribution': (
        ['Elevation', 'Depth', 'Sigma', 'Height'],
        ['Elevation', 'Depth', 'Sigma', 'Height'],
    ),
    'cbx_export_format_bc': (
        ['2dm', 'Shapefile'],
        ['2dm', 'Shapefile'],
    ),
    'cbx_export_format': (
        ['CSV', 'Shapefile'],
        ['CSV', 'Shapefile'],
    ),
}
POINT_BC_CBX_OPTS = {
    'cbx_bc_type': (
        ['QC (Cell Inflow)'],
        ['QC'],
    ),
}
POLYGON_BC_CBX_OPTS = {
    'cbx_bc_type': (
        ['QC_POLY'],
        ['QC_POLY'],
    ),
}
GLOBAL_BC_CBX_OPTS = {
    'cbx_bc_type': (
        ['QG (Global Cell Inflow)'],
        ['QG'],
    ),
}
GRIDDED_BC_CBX_OPTS = {
    'cbx_bc_type': (
        ['MSLP_GRID', 'W10_GRID', 'Wave'],
        ['MSLP_GRID', 'W10_GRID', 'WAVE'],
    ),
}

"""
Label texts for BC CSV column/NetCDF variable selection
"""
BC_VARIABLE_LABEL_TEXT = {
    # Arc BCs
    'HQ': ('H column header:', 'Q column header:'),
    'Q': ('TIME column header:', 'Q column header:'),
    'QN': (),
    'WL': ('TIME column header:', 'WL column header:'),
    'WLS': ('TIME column header:', 'WL_A column header:', 'WL_B column header:'),
    'WL_CURT': ('TIME variable name:', 'CHAINAGE variable name:', 'ELEVATION variable name:', 'WL variable name:'),
    # Point BCs
    'QC': ('TIME column header:', 'Q column header:'),
    # Polygon BCs
    'QC_POLY': ('TIME column header:', 'Q column header:'),
    # Global BCs
    'QG': ('TIME column header:', 'Q/A column header:'),
    # Gridded BCs
    'MSLP_GRID': ('TIME variable name:', 'MSLP variable name:'),
    'W10_GRID': ('TIME variable name:', 'W10_X variable name:', 'W10_Y variable name'),
    'WAVE': (
        'TIME variable name:',
        'HSIGN variable name:',
        'TPS variable name:',
        'DIR variable name:',
        'UBOT variable name:',
        'TMBOT variable name:',
        'FORCE_X variable name:',
        'FORCE_Y variable name:',
        'DEPTH variable name:',
    ),
}
BC_VARIABLE_HIDE_IDX = {  # Index of variable/column names we are hiding for now
    'WL_CURT': 2,  # For now, don't make the user specify the elevation variable. It is for 3D runs.
}

"""
Label texts for default, offset, and scale widgets
"""
ARC_BC_LABEL_TEXT = {
    'lbl_default1': {
        BC_TYPE_HQ: 'Q default:',
        BC_TYPE_Q: 'Q default:',
        BC_TYPE_QN: 'Q default:',
        BC_TYPE_WL: 'WL default:',
        BC_TYPE_WLS: 'WL1 default:',
        BC_TYPE_WL_CURT: 'Elevation default:',
    },
    'lbl_default2': {
        BC_TYPE_HQ: '',
        BC_TYPE_Q: '',
        BC_TYPE_QN: '',
        BC_TYPE_WL: '',
        BC_TYPE_WLS: 'WL2 default:',
        BC_TYPE_WL_CURT: 'WL default:',
    },
    'lbl_offset1': {
        BC_TYPE_HQ: 'Q offset:',
        BC_TYPE_Q: 'Q offset:',
        BC_TYPE_QN: 'Q offset:',
        BC_TYPE_WL: 'WL offset:',
        BC_TYPE_WLS: 'WL1 offset:',
        BC_TYPE_WL_CURT: 'Elevation offset:',
    },
    'lbl_offset2': {
        BC_TYPE_HQ: '',
        BC_TYPE_Q: '',
        BC_TYPE_QN: '',
        BC_TYPE_WL: '',
        BC_TYPE_WLS: 'WL2 offset:',
        BC_TYPE_WL_CURT: 'WL offset:',
    },
    'lbl_scale1': {
        BC_TYPE_HQ: 'Q scale:',
        BC_TYPE_Q: 'Q scale:',
        BC_TYPE_QN: 'Q scale:',
        BC_TYPE_WL: 'WL scale:',
        BC_TYPE_WLS: 'WL1 scale:',
        BC_TYPE_WL_CURT: 'Elevation scale:',
    },
    'lbl_scale2': {
        BC_TYPE_HQ: '',
        BC_TYPE_Q: '',
        BC_TYPE_QN: '',
        BC_TYPE_WL: '',
        BC_TYPE_WLS: 'WL2 scale:',
        BC_TYPE_WL_CURT: 'WL scale:',
    },
}
POINT_BC_LABEL_TEXT = {
    'lbl_default1': {
        BC_TYPE_QC: 'Q default:',
    },
    'lbl_default2': {
        BC_TYPE_QC: '',
    },
    'lbl_offset1': {
        BC_TYPE_QC: 'Q offset:',
    },
    'lbl_offset2': {
        BC_TYPE_QC: '',
    },
    'lbl_scale1': {
        BC_TYPE_QC: 'Q scale:',
    },
    'lbl_scale2': {
        BC_TYPE_QC: '',
    },
}
POLY_BC_LABEL_TEXT = {
    'lbl_default1': {
        BC_TYPE_QC_POLY: 'QC_POLY default:',
    },
    'lbl_default2': {
        BC_TYPE_QC_POLY: '',
    },
    'lbl_offset1': {
        BC_TYPE_QC_POLY: 'QC_POLY offset:',
    },
    'lbl_offset2': {
        BC_TYPE_QC_POLY: '',
    },
    'lbl_scale1': {
        BC_TYPE_QC_POLY: 'QC_POLY scale:',
    },
    'lbl_scale2': {
        BC_TYPE_QC_POLY: '',
    },
}
GLOBAL_BC_LABEL_TEXT = {
    'lbl_default1': {
        BC_TYPE_QG: 'Q/A default:',
    },
    'lbl_default2': {
        BC_TYPE_QG: '',
    },
    'lbl_offset1': {
        BC_TYPE_QG: 'Q/A offset:',
    },
    'lbl_offset2': {
        BC_TYPE_QG: '',
    },
    'lbl_scale1': {
        BC_TYPE_QG: 'Q/A scale:',
    },
    'lbl_scale2': {
        BC_TYPE_QG: '',
    },
}
GRID_BC_LABEL_TEXT = {
    'lbl_default1': {  # Up to 8 fields for WAVE BC
        BC_TYPE_MSLP: 'MSLP default:',
        BC_TYPE_W10: 'W10_X default:',
        BC_TYPE_WAVE: 'HSIGN default:',
    },
    'lbl_default2': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: 'W10_Y default:',
        BC_TYPE_WAVE: 'TPS default:',
    },
    'lbl_default3': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'DIR default:',
    },
    'lbl_default4': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'UBOT default:',
    },
    'lbl_default5': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'TMBOT default:',
    },
    'lbl_default6': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'FORCE_X default:',
    },
    'lbl_default7': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'FORCE_Y default:',
    },
    'lbl_default8': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'DEPTH default:',
    },
    'lbl_offset1': {
        BC_TYPE_MSLP: 'MSLP offset:',
        BC_TYPE_W10: 'W10_X offset:',
        BC_TYPE_WAVE: 'HSIGN offset:',
    },
    'lbl_offset2': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: 'W10_Y offset:',
        BC_TYPE_WAVE: 'TPS offset:',
    },
    'lbl_offset3': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'DIR offset:',
    },
    'lbl_offset4': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'UBOT offset:',
    },
    'lbl_offset5': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'TMBOT offset:',
    },
    'lbl_offset6': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'FORCE_X offset:',
    },
    'lbl_offset7': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'FORCE_Y offset:',
    },
    'lbl_offset8': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'DEPTH offset:',
    },
    'lbl_scale1': {
        BC_TYPE_MSLP: 'MSLP scale:',
        BC_TYPE_W10: 'W10_X scale:',
        BC_TYPE_WAVE: 'HSIGN scale:',
    },
    'lbl_scale2': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: 'W10_Y scale:',
        BC_TYPE_WAVE: 'TPS scale:',
    },
    'lbl_scale3': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'DIR scale:',
    },
    'lbl_scale4': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'UBOT scale:',
    },
    'lbl_scale5': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'TMBOT scale:',
    },
    'lbl_scale6': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'FORCE_X scale:',
    },
    'lbl_scale7': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'FORCE_Y scale:',
    },
    'lbl_scale8': {
        BC_TYPE_MSLP: '',
        BC_TYPE_W10: '',
        BC_TYPE_WAVE: 'DEPTH scale:',
    },
}
