"""Mappings between TUFLOWFV card values and dialog texts."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"


WIND_STRESS_OPT_WU = 1
WIND_STRESS_OPT_CONSTANT = 2
WIND_STRESS_OPT_KONDO = 3

HORIZ_MIXING_OPT_NONE = 0
HORIZ_MIXING_OPT_CONSTANT = 1
HORIZ_MIXING_OPT_SMAGORINSKY = 2
HORIZ_MIXING_OPT_WU = 3

HORIZ_DIFFUSIVITY_OPT_NONE = 0
HORIZ_DIFFUSIVITY_OPT_CONSTANT = 1
HORIZ_DIFFUSIVITY_OPT_SMAGORINSKY = 2
HORIZ_DIFFUSIVITY_OPT_ELDER = 3
HORIZ_DIFFUSIVITY_OPT_WARMUP = 4

# {combobox name: ([option texts], [export value])}
MC_CBX_OPTS = {
    'cbx_spatial_order_horiz': (
        ['1st', '2nd'],
        [1, 2]
    ),
    'cbx_spatial_order_vert': (
        ['1st', '2nd'],
        [1, 2]
    ),
    'cbx_hardware_solver': (
        ['CPU', 'GPU'],
        ['CPU', 'GPU']
    ),
    'cbx_global_roughness': (
        ['Manning', 'KS'],
        ['Manning', 'ks']
    ),
    'cbx_mixing_model_horiz': (
        ['None', 'Constant', 'Smagorinsky', 'Wu'],
        ['None', 'Constant', 'Smagorinsky', 'Wu'],
    ),
    'cbx_mixing_model_vert': (
        ['Constant', 'Parametric', 'External'],
        ['Constant', 'Parametric', 'External'],
    ),
    'cbx_global_horiz_diffusivity': (
        ['None', 'Constant', 'Smagorinsky', 'Elder', 'Warmup'],
        ['None', 'Constant', 'Smagorinsky', 'Elder', 'Warmup'],
    ),
    'cbx_vertical_mesh_type': (
        ['Sigma', 'Z'],
        ['Sigma', 'Z']
    ),
    'cbx_layer_faces': (
        ['CSV', 'Specified'],
        ['CSV', 'Spec']
    ),
    'cbx_wind_stress': (
        ['Wu', 'Constant', 'Kondo'],
        [WIND_STRESS_OPT_WU, WIND_STRESS_OPT_CONSTANT, WIND_STRESS_OPT_KONDO],
    ),
    'cbx_statistics': (
        ['Both', 'Minimums', 'Maximums'],
        ['Both', 'min', 'max']
    ),
}
