"""Filter model for the output coverages table."""
# 1. Standard python modules

# 2. Third party modules
from PySide2.QtCore import QSortFilterProxyModel, Qt

# 3. Aquaveo modules

# 4. Local modules


COL_IDX_DEFINE_GRID = 0
COL_IDX_ADD_BCS = 1


class OutputCoveragesFilterModel(QSortFilterProxyModel):
    """A model to set 1-based vertical headers.."""

    def __init__(self, parent=None):
        """Initializes the filter model.

        Args:
            parent (QWidget): The parent object.
        """
        super().__init__(parent)

    def headerData(self, section, orientation, role=Qt.DisplayRole):  # noqa: N802
        """Returns the data for the given role and section in the header.

        Args:
            section (int): The section.
            orientation (:obj:`Qt.Orientation`): The orientation.
            role (int): The role.

        Returns:
            The data.
        """
        if role != Qt.DisplayRole:
            return super().headerData(section, orientation, role)

        if orientation == Qt.Vertical:
            return str(section + 1)
        else:
            return super().headerData(section, orientation, role)
