import sys
import time
import logging

"""Sleep while pydev isn't attached."""
# VSCode will import pydevd when the debugger attaches we will just spin until we see it.
logger = logging.getLogger('xms.tuflowfv')
logger.info('Waiting for debugger to attach...')
while 'pydevd' not in sys.modules:
    time.sleep(0.3)

# Now that pydevd is imported, it probably means someone attached a debugger. It also means, though,
# that we have access to the tools we need to check if there is a debugger attached, so let's do that first.
import pydevd  # Don't worry if this can't be found. It will be added when the debugger attaches.

logger.info('Waiting for debugger to connect...')
while pydevd.get_global_debugger() is None or not pydevd.get_global_debugger().ready_to_run:
    time.sleep(0.3)

logger.info('Debugger connected.')