"""BcCoverageComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2022"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.components.coverage_component import CoverageComponent

# 4. Local modules
from xms.wash.components import bc_generic_model


class BcCoverageComponent(CoverageComponent):
    """A component for boundary conditions."""
    def __init__(self, main_file: str) -> None:
        """Initializes the class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file, generic_model=bc_generic_model.create())
        self._inactive_group_name = ''  # Overriden from base class cause our group names are strings
        # We shouldn't actually need to do anything with _multiple_active_group_name since we use exclusive groups,
        # but in case that changes in the future...
        self._multiple_active_group_name = '$MGROUP$'  # Overriden from base class cause our group names are strings
