import param

from .operation_parameters import OperationParameters
from .iteration_parameters import IterationParameters
from .constituent_properties import ConstituentProperties
from .model_constants import ModelConstants
from .output_control import OutputControl
from .sediment_constituent_properties import SedimentConstituentProperties
from .sediment_properties import SedimentProperties
from .time_control import TimeControl
from .advanced_cards import AdvancedCards


class ModelControl(param.Parameterized):
    time_control = param.ClassSelector(default=TimeControl(), class_=TimeControl)
    output_control = param.ClassSelector(default=OutputControl(), class_=OutputControl)
    operation_parameters = param.ClassSelector(default=OperationParameters(), class_=OperationParameters)
    iteration_parameters = param.ClassSelector(default=IterationParameters(), class_=IterationParameters)
    constituent_properties = param.ClassSelector(default=ConstituentProperties(), class_=ConstituentProperties)
    sediment_constituent_properties = param.ClassSelector(default=SedimentConstituentProperties(),
                                                          class_=SedimentConstituentProperties)
    sediment_properties = param.ClassSelector(default=SedimentProperties(), class_=SedimentProperties)
    model_constants = param.ClassSelector(default=ModelConstants(), class_=ModelConstants)
    advanced_cards = param.ClassSelector(default=AdvancedCards(), class_=AdvancedCards)

    def __init__(self, **params):
        super(ModelControl, self).__init__(**params)
        self.time_control = TimeControl()
        self.output_control = OutputControl()
        self.operation_parameters = OperationParameters()
        self.iteration_parameters = IterationParameters()
        self.constituent_properties = ConstituentProperties()
        self.sediment_constituent_properties = SedimentConstituentProperties()
        self.model_constants = ModelConstants()
        self.advanced_cards = AdvancedCards()
