"""This module defines the base class to store project settings."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.FhwaVariable.core_data.calculator.calcdata import CalcData
from xms.FhwaVariable.core_data.calculator.setting_group import SettingGroup
# from xms.FhwaVariable.core_data.variables.variable import Variable


class ProjectSettingsCalc(SettingGroup, CalcData):
    """A class that defines the program settings."""

    def __init__(self, name: str = 'HydraulicToolbox', version: str = '0.1', agency: str = 'FHWA',
                 developed_by: str = 'Aquaveo', app_data=None):
        """Initializes the Settings CalcData."""
        SettingGroup.__init__(self, name, version, agency, developed_by, app_data=app_data)
        CalcData.__init__(self, app_data=app_data)

        self.name = 'Project Settings'
        self.type = 'ProjectSettingsCalc'
        self.uuid = uuid.uuid4()

        self.calc_support_dual_input = False  # Displays a second column of input (HY-8 Style)
        self.calc_support_warnings = False  # Displays the warnings text box
        self.calc_support_results = False  # Displays the Results table box
        self.calc_support_plot = False  # Displays the plot

        self.dlg_width = 800
        self.dlg_height = 600

        # input
        self.input = {}
        self.calc_support_dual_input = False

        self.unknown = None

        # Results
        self.results = {}

        self.warnings = []

        # plot

        # Help/Wiki
        # self.self.help_url = 'https://www.xmswiki.com/wiki/SMS:SRH-2D_Channel_Calculator'

    def get_input_tab_group(self, unknown=None):
        """Get the input group (for user-input).

        Returns
            input_vars (list of variables): input group of variables
        """
        input_vars = {}

        for input in self.input:
            if isinstance(self.input[input], dict):
                continue
            input_vars[input] = self.input[input].get_val().get_input_group()

        return input_vars
