"""Model view class for CalcData definitions in the model interactor."""
__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field
from uuid import UUID, uuid4

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class CalcDataItem:
    """A class that defines the about information for a CalcData item in the CalcData dict.

    Args:
        name: name of the CalcData (required)
        item_class: class of the CalcData (required)
        calc_uuid: uuid of the CalcData (auto-generated if None)
        icon: path to the icon
        tool_tip: tool tip
        menu_group: Add this CalcData to the menu as a sub-menu under this name
        add_toolbar: Add this CalcData to the toolbar
        complexity: The complexity level of this CalcData
    """
    name: str
    item_class: type
    calc_uuid: UUID | None = None
    icon: str | None = None
    tool_tip: str | None = None
    menu_group: str = ''
    add_toolbar: bool = True
    complexity: int = 0
    assignments: list = field(default_factory=list)
    uuid: UUID = field(init=False)

    def __post_init__(self):
        """Initialize UUID after other fields are set. Generates a new UUID if calc_uuid is None."""
        self.uuid = self.calc_uuid if self.calc_uuid is not None else uuid4()
