"""Classes to provide data for the project explorer."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass
from uuid import UUID

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class TreeData:
    """Data class to hold data specific to the tree items for the data.

    Args:
        icon: The icon for the item
        is_checked: True if the item is checked
        is_expanded: True if the item is expanded
        is_selected: True if the item is selected
        parent_uuid: The uuid of the parent of the item
    """
    icon: str | None = None
    is_checked: bool = False
    is_expanded: bool = False
    is_selected: bool = False
    parent_uuid: UUID | None = None
    is_editing: bool = False
    is_drag_enabled: bool = True
    is_drop_enabled: bool = False
    is_read_only: bool = False
