"""Mappings between ADCIRC magic numbers and dialog texts."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"

# {combobox name: ([option texts], [export value])}
MC_CBX_OPTS = {
    # General parameters tab
    'cbx_hot_start':
        (
            [
                'None: cold start',
                'ASCII fort.17',
                'Binary fort.67',
                'Binary fort.68',
                'NetCDF fort.67.nc',
                'NetCDF fort.68.nc',
                'NetCDF4 fort.67.nc',
                'NetCDF4 fort.68.nc',
            ], [0, 17, 67, 68, 367, 368, 567, 568]
        ),
    'cbx_nolibf':
        (
            [
                'Linear bottom friction',
                'Quadratic bottom friction',
                'Hybrid nonlinear bottom friction',
                'Quadratic friction nodal attribute - Fric',
                "Manning's N nodal attribute - ManningsN",
                'Chezy C nodal attribute - ChezyFric',
                'Bottom roughness length - Z0b_var',
            ],
            [
                0,
                1,
                2,
                3,
                4,
                5,
                6  # 3-6 are nodal attributes and require a dataset to be selected
            ]
        ),
    'cbx_ncor': ([
        'Constant',
        'Variable',], [0, 1]),
    'cbx_nabout': ([
        'Debug',
        'Echo',
        'Info',
        'Warning',
        'Error',], [-1, 0, 1, 2, 3]),
    # Model formulation tab
    'cbx_im': ([
        'Barotropic 2DDI',
        'Barotropic 3D',
        'Baroclinic 3D',
        'Barotropic 2DDI using lumped GWCE (explicit)',
        'Barotropic 3D using lumped GWCE (explicit)',], [0, 1, 21, 111112, 611112]),
    'cbx_iden': ([
        'Diagnostic w/ salinity and temperature',
        'Diagnostic w/ temperature',
        'Diagnostic w/ salinity',
        'Diagnostic w/ sigma T',
        'Prognostic w/ salinity and temperature',
        'Prognostic w/ temperature',
        'Prognostic w/ salinity',
        'Prognostic w/ sigma T',], [-4, -3, -2, -1, 4, 3, 2, 1]),
    'cbx_nolifa': (['None', 'No wetting/drying', 'With wetting/drying'], [0, 1, 2]),
    'cbx_tau0': ([
        'Pure wave equation: TAU0 = 0',
        'Pure primitive equation: TAU0 specified',
        'Spatially discrete/time constant: TAU0 = -1',
        'Spatially variable/time constant: TAU0 = -2',
        'From nodal attribute: TAU0 = -3',
        'From local friction: TAU0 = -5',], [0, 1, -1, -2, -3, -5]),  # > 0 is specified
    'cbx_ititer': (['Lumped', 'JCG solver'], [-1, 1]),
    'cbx_isldia': ([
        'Fatal', 'Warnings and minimum', 'Algorithm progress', 'Parameters and info',
        'Approx solution/iter', 'Original system'], [0, 1, 2, 3, 4, 5]),
    # Timing tab
    'cbx_nramp': (['0', '1', '2', '3', '4', '5', '6', '7', '8'], [0, 1, 2, 3, 4, 5, 6, 7, 8]),
    # Output tab
    'cbx_nhstar': (['Off', 'Binary', 'NetCDF', 'NetCDF4'], [0, 1, 3, 5]),
    # Wind tab
    'cbx_nws': ([
        'NWS =    0 - No Wind', 'NWS =    1 - Stress/Pressure - every node/every timestep',
        'NWS =    2 - Stress/Pressure - every node/time interval',
        'NWS =    3 - Velocity in US Navy Fleet Numeric format',
        'NWS =    4 - Velocity/Pressure in PBL/JAG format',
        'NWS =    5 - Velocity/Pressure - every node/time interval', 'NWS =    6 - Velocity/Pressure on grid',
        'NWS =    8 - Symmetric cyclonic storm from path', 'NWS =   10 - 10m Velocity/Pressure NWS AVN files',
        'NWS =   11 - 10m Velocity/Pressure NWS ETA 29km files', 'NWS =   12 - Velocity/Pressure OWI files',
        'NWS =   15 - HWind files', 'NWS =   16 - GFDL files',
        'NWS =   19 - Asymmetric cyclonic storm from path', 'NWS =   20 - GAHM Format cyclonic storm path'
    ], [0, 1, 2, 3, 4, 5, 6, 8, 10, 11, 12, 15, 16, 19, 20]),
    'cbx_wind_pressure_relationship': (['Dvorak', 'Knaffzehr', 'Specified central pressure', 'Background'],
                                       ['dvorak', 'knaffzehr', 'specifiedPc', 'background']),
    'cbx_geofactor': (['Full gradient equation', 'Simplifying cyclostrophic balance equation'], [1, 0]),
    'cbx_wave_radiation': (['None', 'Forcing dataset', 'SWAN coupled', 'STWAVE coupled'], [0, 100, 300, 400]),
    # Advanced tab
    'cbx_nddt': (['Not used', 'Full domain', 'Subdomain'], [0, 1, 2]),
}

TAU0_SPECIFIED_NOTE = (
    'Guidance: Set TAU0 to the largest value of an equivalent linear friction factor.\n   '
    '- For linear friction TAU0 = TAU\n   '
    '- For quadratic friction TAU0 = maximum(speed*CF/depth)\n   '
    '- Typical values for TAU0 vary from 0.005 to 0.1')

TAU0_DISCRETE_NOTE = (
    'Guidance: Tau0 is calculated according to depth.\n   '
    '- If the depth is less than 10, TAU0 is set to 0.005\n   '
    '- If the depth is greater than 10, TAU0 is set to 0.020'
)

TAU0_VARIABLE_NOTE = (
    'Guidance: Tau0 is calculated according to depth.\n   '
    '- If the depth is more than 200, TAU0 is set to 0.005\n   '
    '- If the depth is between 200 and 1, then TAU0 is set to 1/depth\n   '
    '- If depth less than 1, TAU0 is set to 1.0'
)

TAU0_NODAL_NOTE = (
    'Guidance: Tau0 is computed from TAU0Base read in from nodal attribute file.\n   '
    '- If TAU0Base is less than 0.025, Tau0 = TAU0Base (constant in time).\n   '
    '- If TAU0Base greater than 0.025, Tau0 = TAU0Base + 1.5 TK(i) where TK(i)=Cd|U|/H'
)
