"""Imports an AdH simulation."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query
from xms.guipy.dialogs.feedback_thread import FeedbackThread
from xms.guipy.dialogs.process_feedback_dlg import run_feedback_dialog

# 4. Local modules
from xms.adh.data.xms_query_data import XmsQueryData
from xms.adh.file_io.write_simulation import write_adh_simulation


def write_simulation_with_feedback(query: Query) -> bool:
    """Imports AdH data and displays feedback using a feedback dialog.

    Returns:
        True if writing was successful.
    """
    class WriteSimulationThread(FeedbackThread):
        """Feedback thread for importing AdH files."""
        def __init__(self):
            """Initialize the AdH import thread."""
            super().__init__(create_query=False, is_export=True)
            self._query = query
            task = 'Write AdH Simulation'
            self.display_text |= {
                'title': task,
                'working_prompt': f'Running {task}. Please wait...',
                'warning_prompt': f'Warning(s) encountered during {task}. Review log output for more details.',
                'error_prompt': f'Error(s) encountered during {task}. Review log output for more details.',
                'success_prompt': f'Successfully ran {task}.',
            }

        def _run(self):
            """Run AdH simulation import."""
            xms_data = XmsQueryData(self._query)
            self.success = write_adh_simulation(xms_data)

    worker = WriteSimulationThread()
    success = run_feedback_dialog(worker)
    return success
