"""Utilities to help with export tests."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
import xms.api._xmsapi.dmi as xmd
from xms.api.tree.tree_node import TreeNode

# 4. Local modules


def create_tree_node_from_dict(obj_dict):
    """Changes a dictionary item into a TreeNode.

    Args:
        obj_dict (dict): A dictionary with items describing an item in the project explorer.

    Returns:
        A TreeNode with the name, UUID, and children set.
    """
    if 'Name' in obj_dict:
        data_obj = xmd.ProjectExplorerItem()
        data_obj.SetName(obj_dict['Name'])
        data_obj.SetUuid(obj_dict['Uuid'])
        data_obj.SetIsPointerItem(obj_dict['Is_Pointer'])
        obj = TreeNode(data_obj)
        for child in obj_dict['Children']:
            obj._children.append(child)
        return obj
    return obj_dict
