"""This is a table widget for specifying the start and end times for output, as well as output interval."""

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import QAbstractItemView

# 3. Aquaveo modules
from xms.guipy.delegates.edit_field_validator import EditFieldValidator
from xms.guipy.models.rename_model import RenameModel
from xms.guipy.validators.qx_double_validator import QxDoubleValidator

# 4. Local modules
from xms.cmsflow.gui.cmsflow_table_widget import CmsflowTableWidget


class OutputListTableWidget(CmsflowTableWidget):
    """Table widget base class."""
    def __init__(self, parent, data_frame, fixed_size=False):
        """Construct the widget.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
            data_frame (pandas.DataFrame): The model data.
            fixed_size (bool): True if the table is a fixed size.
        """
        self.rename_model = None
        self.fixed_size = fixed_size
        self.edit_delegate = None
        self.dbl_validator = None
        super().__init__(parent, data_frame, 0, {'start_time': 0.0, 'increment': 0.0, 'end_time': 0.0})

    def setup_ui(self):
        """Sets up the delegates, validators, and filter model for this table."""
        self.rename_model = RenameModel(['Start time (hrs)', 'Increment (hrs)', 'End time (hrs)'], self)
        self.dbl_validator = QxDoubleValidator(parent=self)
        self.edit_delegate = EditFieldValidator(self.dbl_validator)
        delegates = {0: self.edit_delegate, 1: self.edit_delegate, 2: self.edit_delegate}
        super()._setup_ui(delegates, False, self.fixed_size, self.rename_model)
        self.table_view.setEditTriggers(QAbstractItemView.AllEditTriggers)
