"""This is a widget for stacking widgets that are of varying sizes."""

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import QStackedWidget

# 3. Aquaveo modules

# 4. Local modules


class ResizingStackedWidget(QStackedWidget):
    """This class is for making a stack that is only as big as the current widget."""
    def __init__(self, parent):
        """This class resizes to the smallest size it thinks is possible with each change of the current index.

        Since this is a promoted widget, after creating the *.py file from the *.ui file,
         change the resulting 'import ResizingStackedWidget' to
        'from cmsflow.gui.resizing_stacked_widget import ResizingStackedWidget'.

        Args:
            parent (QWidget): The parent of this widget.
        """
        super().__init__(parent)

    def sizeHint(self):  # noqa: N802
        """Returns the minimum size hint for the current page."""
        return self.currentWidget().minimumSizeHint()

    def minimumSizeHint(self):  # noqa: N802
        """Returns the minimum size hint for the current page."""
        return self.currentWidget().minimumSizeHint()
