from . import _xmsconstraint
from . import Grid
from .grid import GridType


class UGrid3d(Grid):
    """A constrained UGrid containing only 3D cells."""

    def __init__(self, ugrid=None, instance=None):
        """Initializer for UGrid3d. Must be given either a UGrid or a C++ instance.

        Args:
            ugrid: An optional UGrid.
            instance: An optional C++ instance.
        """
        if ugrid:
            instance = _xmsconstraint.constraint.CoUGrid3d(ugrid._instance)
        if not instance:
            raise ValueError('Attempted to make a UGrid3d without a ugrid '
                             'or instance.')
        Grid.__init__(self, instance)

    @property
    def grid_type(self):
        """GridType of the constraint."""
        return GridType.ugrid_3d
