"""XMS legend display options."""

# 1. Standard Python modules
from enum import IntEnum

# 2. Third party modules
from PySide2.QtCore import QSize
from PySide2.QtGui import QColor, QFont

# 3. Aquaveo modules

# 4. Local modules


# in order XMS is expecting
class LegendLocation(IntEnum):
    """An enumeration possible of legend locations."""
    top_left_corner = 0
    bottom_left_corner = 1
    top_right_corner = 2
    bottom_right_corner = 3
    screen_location = 4
    world_location = 5


class LegendOptions:
    """A class to hold the display options."""
    location_text = {
        LegendLocation.top_left_corner: "Top left corner",
        LegendLocation.bottom_left_corner: "Bottom left corner",
        LegendLocation.top_right_corner: "Top right corner",
        LegendLocation.bottom_right_corner: "Bottom right corner",
        LegendLocation.screen_location: "Screen location",
        LegendLocation.world_location: "World location",
    }

    def __init__(self):
        """Construct default legend display options."""
        self.color = QColor('black')
        self.font = QFont("Arial", 8)
        self.location = LegendLocation.top_left_corner
        self.size = QSize(20, 20)
        self.title = ""
        self.x = 0.0
        self.y = 0.0
        self.z = 0.0
        self.use_scientific = False
        self.equal_color_segment_height = False
        self.is_contour = False
