"""FileData class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules
from typing import Any, Optional, TextIO

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class FileData:
    """Data needed by Section class to write to the file."""
    def __init__(self) -> None:
        """Initializes the class."""
        # These 3 are used by the SectionBase class
        self.file: Optional[TextIO] = None
        self.data: Optional[dict[Any, Any]] = None
        from xms.hgs.file_io.section import SectionBase  # This is here to avoid circular imports
        self.section_stack: list[SectionBase] = []
