"""DisReader class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.grid_info import DisEnum
from xms.mf6.file_io.dis_reader_base import DisReaderBase


class DisReader(DisReaderBase):
    """Reads a DIS package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__(ftype='DIS6')

    def _read_dimensions(self, line):
        """Reads the dimensions block.

        Args:
            line (str): A line from the file.
        """
        # if not self._data.grid_info:
        #     self._data.grid_info = GridInfo()

        words = line.split()
        if words and len(words) > 1:
            if words[0].upper() == 'NLAY':
                self._data.grid_info().nlay = int(words[1])
            elif words[0].upper() == 'NROW':
                self._data.grid_info().nrow = int(words[1])
            elif words[0].upper() == 'NCOL':
                self._data.grid_info().ncol = int(words[1])

        self._data.grid_info().dis_enum = DisEnum.DIS
