"""SsmWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.list_package_writer import ListPackageWriter


class SsmWriter(ListPackageWriter):
    """Writes a SSM package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()

    def _write_package(self, data):
        """Writes the package file.

        Args:
            data (SsmData): Package data.
        """
        self._data = data
        with open(self._data.filename, 'w') as fp:
            self._write_comments(fp)
            self._write_options(fp)
            self._write_list_block('SOURCES', fp)
