"""MapperInputs class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field

# 2. Third party modules

# 3. Aquaveo modules
from xms.data_objects.parameters import Coverage

# 4. Local modules
from xms.mf6.data.base_file_data import BaseFileData
from xms.mf6.gui.map_from_coverage_dialog import MapOpt

# Types
AttFiles = dict[str, str]  # feature type (i.e. 'points', 'arcs', 'polygons') -> filepath


@dataclass
class CovAndAtts:
    """A coverage and it's att files."""
    coverage: Coverage | None = None
    att_files: AttFiles = field(default_factory=dict)


CovData = dict[str, CovAndAtts]  # coverage uuid -> CovAndAtts


@dataclass
class MapperInputs:
    """Information needed to map from coverage."""
    coverage_data: CovData = field(default_factory=dict)
    package: BaseFileData | None = None
    append_or_replace: MapOpt = MapOpt.APPEND
    shapefilepath: str = ''
    override_layers: bool = False  # True to specify a .csv file used to override grid layers
    layer_filepath: str = ''  # Filepath of layer file used to override grid layers
