"""Entry point for the model run tracker."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = []

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query
from xms.components.dmi.xms_data import XmsData

# 4. Local modules
from xms.ptm.dmi.model_run_tracker import PtmModelRunTracker

if __name__ == '__main__':  # pragma: no cover
    data = XmsData(query=Query(progress_script=True))
    tracker = PtmModelRunTracker(data)
    tracker.start_tracking()
