"""Module for reading and writing UGrid files."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = ['write_grid']

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules
from xms.constraint import UGrid2d
from xms.ptmio.fort14.geometry import Geometry
from xms.ptmio.fort14.geometry_writer import write_geometry

# 4. Local modules


def write_grid(grid: UGrid2d, where: str | Path):
    """
    Write a UGrid to disk.

    Args:
        grid: The grid to write.
        where: Where to write it.
    """
    geometry = Geometry(header='ADCIRC grid written by PTM interface', ugrid=grid.ugrid)
    write_geometry(geometry, where)
