"""Class for writing wcd monitor data to model input files."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.rsm.file_io.monitor_writer import MonitorWriter


class WcdMonitorWriter(MonitorWriter):
    """Writer class for the RSM control file."""
    def __init__(self, xml_parent, monitor_data, monitor_wm_ids=None):
        """Constructor.

        Args:
            xml_parent (xml.etree.cElementTree.Element): xml parent element
            monitor_data (list): list of monitor data to write
            monitor_wm_ids (list, optional): list of water mover ids to write. Defaults to None.
        """
        super().__init__(xml_parent, [])
        self._monitor_xml_name = 'wcdmonitor'
        self._monitor_to_write = monitor_data
        self._feature_type = 'polygon'
        self._monitor_wm_ids = monitor_wm_ids if monitor_wm_ids else []

    def write(self):
        """Write the lake monitor data to the xml."""
        self._write_all_monitor()
