"""BcDataArcs class."""

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class BcDataFlowDirection(param.Parameterized):
    """Flow direction data for a structure."""
    specify_flow_direction = param.Boolean(
        label='Specify downstream flow direction',
        default=False,
        doc='Enables the option to specify the flow direction on a structure.',
        precedence=1,
    )
    x_direction = param.Number(
        default=0.0,
        doc='X direction of down stream flow',
        precedence=2,
    )
    y_direction = param.Number(
        default=0.0,
        doc='Y direction of down stream flow',
        precedence=3,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.doing_update = False
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=['specify_flow_direction'],
            depends={'specify_flow_direction': ['x_direction', 'y_direction']},
        )

    @param.depends('specify_flow_direction', watch=True)
    def _update_specify_flow_direction(self):
        """Watches changes made to the specify_flow_direction object."""
        self.enabler.do_enabling(force_disable=False)
