"""BcDataWall class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class BcDataWall(param.Parameterized):
    """Bc type wall data."""
    extra_wall_roughness = param.Boolean(
        label='Add extra roughness at wall boundary',
        default=False,
        doc='option for adding extra wall roughness',
        precedence=1,
    )
    roughness = param.Number(
        label='Roughness height in mm',
        default=0.0,
        doc='',
        precedence=2,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=['extra_wall_roughness'],
            depends={
                'extra_wall_roughness': ['roughness'],
            },
        )

    @param.depends('extra_wall_roughness', watch=True)
    def _update_extra_wall_roughness(self):
        """Watches changes made to the extra_wall_roughness object."""
        self.enabler.do_enabling(force_disable=False)
