"""MonitorPoint class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class MonitorArc(param.Parameterized):
    """Data for monitor points."""
    label = param.String(label='Label', default='', doc='Label for the monitor point', precedence=1)

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=[],
            depends={},
        )
