"""FillHolesInUGridTool class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.tool_core import IoDirection

# 4. Local modules
from xms.tool.ugrids import FillHolesInUGridTool

ARG_INPUT_UGRID = 0
ARG_OUTPUT_GRID = 1


class FillHolesIn2dMeshTool(FillHolesInUGridTool):
    """Tool to fill in holes in grids."""

    def __init__(self):
        """Initializes the class."""
        super().__init__(name='Fill Holes in 2D Mesh')
        self._force_ugrid = False
        self._geom_txt = 'mesh'

    def initial_arguments(self):
        """Get initial arguments for tool.

        Must override.

        Returns:
            (list): A list of the initial tool arguments.
        """
        arguments = [
            self.grid_argument(name='input_ugrid', description='2D Mesh', io_direction=IoDirection.INPUT),
            self.grid_argument(name='grid', description='New Mesh Name',
                               optional=True, io_direction=IoDirection.OUTPUT),
        ]
        return arguments
