"""Classes to Define the view model of a message box."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class MessageBox():
    """Select a file."""

    def __init__(self, msg_uuid: str = None):
        """Initialize the message box class."""
        self.uuid = msg_uuid
        if self.uuid is None:
            self.uuid = uuid.uuid4()

        self.parent = None
        self.parent_uuid = None
        self.window_title: str = "Warning"
        self.message_text: str = ""
        # 'information', 'warning', 'critical', 'question'
        self.message_type: str = 'warning'
        # 'ok', 'cancel', 'yes', 'no', 'abort', 'retry', 'ignore', 'close', 'help', 'apply', 'reset'
        self.buttons: list[str] = field(default_factory=list('ok'))
