"""Classes to Define the model-view of a tool (toolbar or menu)."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class ToolItem:
    """Data class to hold commands that are executed. Used to keep an undo/redo history."""

    def __init__(self, name: str = '', tool_uuid: uuid.UUID = None, command=None, is_separator: bool = False,
                 icon: str = None, tool_tip: str = None, shortcut: str = None, var=None, item_uuid: uuid.UUID = None,
                 menu_group: str = '', add_toolbar: bool = True, complexity: int = 0):
        """Initialize the ToolItem class.

        Args:
            name (string): Text shown to the user
            tool_uuid (UUID): Unique identifier for the tool
            command (function): functor to call function
            is_separator (bool): If the tool is a separator
            icon (string): Icon to display
            tool_tip (string): Tooltip to display
            shortcut (string): Keyboard shortcut
            var (FhwaVariable): Variable to build/control the tool
            item_uuid (UUID): Unique identifier for the item that tool represents
            menu_group (string): Add this item in a subgroup with this name (if None, remove from menu)
            add_toolbar (bool): Add this item to the toolbar
            complexity (int): Complexity level of the command
        """
        self.uuid = tool_uuid
        if self.uuid is None:
            self.uuid = uuid.uuid4()

        self.name = name
        self.command = command
        self.args = ()
        self.kwargs = {}
        self.is_separator = is_separator
        self.icon = icon
        self.tool_tip = tool_tip
        self.status_message = tool_tip
        self.shortcut = shortcut
        self.var = var
        self.is_enabled = True
        self.is_checked = None
        self.exit = False
        self.uuid = uuid.uuid4()
        self.item_uuid = item_uuid

        self.menu_group = menu_group
        self.add_toolbar = add_toolbar
        self.complexity = complexity

    def set_args_and_kwargs(self, *args, **kwargs):
        """Set the args and kwargs for the command.

        Args:
            args (list): List of arguments
            kwargs (dict): Dictionary of keyword arguments
        """
        self.args = args
        self.kwargs = kwargs
