"""Abstract Class that defines the base functionality for a File IO plug-in."""
__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
from abc import ABC, abstractmethod

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class WriteManagerBase(ABC):
    """Provides a class that will take calcdatas and save them to a given file."""

    def __init__(self, app_name, app_version):
        """Initialize the WriteCalculator Class.
        """
        self.app_name = app_name
        self.app_version = app_version

    @abstractmethod
    def write(self, root_items, filename, overwrite):
        """Exports the calcdatas to a given filename.

        Args:
            root_items (list or tree): the list or tree of items to save to a file
            filename (string): filename to write
            overwrite (bool): Overwrite the file if it exists?
        """
        pass

    @abstractmethod
    def check_for_file_lock(self, filename, overwrite):
        """Simple check if the filename is available to write.

        Args:
            filename (string): filename to check
            overwrite (bool): should we overwrite the file?

        Returns:
            True if the file can be written (or overwritten) to.
            False if the file exists (and can't overwrite) or is locked.
        """
        pass
