"""Pile Stem Data."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.FhwaVariable.core_data.calculator.calculator import Calculator

# 4. Local modules


class PierStemCalc(Calculator):
    """Provides a class that will Handle input for complex pier pile caps."""

    def _get_can_compute(self):
        """Determines if there is enough data to make a computation and if there isn't, add a warning for each reason.

        Args:
            unknown (string): variable that is unknown and being calculated.

        Returns:
            bool: True if can compute
        """
        vars_to_check = ['Pier width (ap)']
        if self.get_data('Pier shape (K1)')[1] not in ['Circular Cylinder', 'Group of Cylinders']:
            vars_to_check.append('Pier length (Lp)')
        if self.is_hec18_complex:
            vars_to_check.append('Distance between front edge (f)')
        result = self.check_float_vars_to_greater_zero(vars_to_check)

        return result
