"""MappedFlowComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.adcirc.components.adcirc_component import AdcircComponent
from xms.adcirc.data.mapped_flow_data import MappedFlowData
from xms.adcirc.gui.mapped_tidal_dlg import MappedTidalDlg


class MappedFlowComponent(AdcircComponent):
    """A hidden Dynamic Model Interface (DMI) component for the mapped flow component."""
    def __init__(self, main_file):
        """Initializes the mapped flow component class.

        Args:
            main_file: The main file associated with this component.

        """
        super().__init__(main_file)
        self.data = MappedFlowData(self.main_file)
        self.tree_commands = [('Flow Constituents...', 'view_flow_constituents')]

    def view_flow_constituents(self, query, params, win_cont):
        """Display the Flow Constituents and persist data if accepted.

        Args:
            query (:obj:`xms.api.dmi.Query`): Object for communicating with XMS
            params (:obj:`dict`): The ActionRequest parameter map
            win_cont (:obj:`QWidget`): The parent window

        Returns:
            (:obj:`tuple`): tuple containing:

                messages (:obj:`list[tuple(str)]`): List of tuples with the first element of the
                tuple being the message level (DEBUG, ERROR, WARNING, INFO) and the second element being the message
                text.

                action_requests (:obj:`list[xms.api.dmi.ActionRequest]`): List of actions for XMS to perform.

        """
        dlg = MappedTidalDlg(self.data, False, win_cont)
        dlg.setModal(True)
        if dlg.exec():
            self.data.commit()
        return [], []
