"""The Arc properties tab in the Structure properties dialog."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.tool_core.table_definition import IntColumnType, StringColumnType, TableDefinition

# 4. Local modules
from xms.bridge.gui.struct_dlg.arc_props_base import ArcPropsBase

ARC_TYPE_EMBANKMENT = 'Embankment'
ARC_TYPE_CULVERT = 'Culvert'
ARC_TYPE_ABUTMENT = 'Abutment'


class CulvertArcProps(ArcPropsBase):
    """The arc properties tab in the structure dialog."""
    def _table_definition(self):
        choices = [
            'Unassigned',
            ARC_TYPE_EMBANKMENT,
            ARC_TYPE_CULVERT,
            ARC_TYPE_ABUTMENT,
        ]
        return TableDefinition(
            [
                IntColumnType(header='Arc ID', enabled=False, default=0),
                StringColumnType(header='Type', choices=choices, default='Unassigned'),
            ]
        )

    def _get_default_arc_data(self, arc_ids):
        """Get the default arc data."""
        default_vals = {
            self._col_names[0]: arc_ids,
            self._col_names[1]: ['Unassigned'] * len(arc_ids),
        }
        return default_vals

    def _get_arc_property_csv_str(self):
        """Get the arc property CSV string."""
        return self._parent.data.data_dict.get('culvert_arc_properties', '')
