from .. import _xmsconstraint


class UGrid2dContour:
    """Computes 2D contours for UGrids."""
    def __init__(self, ugrid):
        self._instance = _xmsconstraint.contour.XmUGrid2dContour(ugrid._instance)
        self.xmugrid = ugrid._instance

    def set_grid_point_scalars(self, point_scalars, activity, activity_type):
        """
        Setup point scalars to be used to contour data.
        Args:
            point_scalars: The point scalars.
            activity: The activity of the points.
            activity_type: The location at which the data is currently stored.
        """
        self._instance.SetGridPointScalars(point_scalars, activity, activity_type)

    def set_grid_cell_scalars(self, cell_scalars, activity, activity_type):
        """
        Setup cell scalars to be used to contour data.
        Args:
            cell_scalars: The cell scalars.
            activity: The activity of the cells.
            activity_type: The location at which the data is currently stored.
        """
        self._instance.SetGridCellScalars(cell_scalars, activity, activity_type)

    def set_extract_scalars(self, scalars):
        """
        Sets values for extracting contours.
        Args:
            scalars: The contour values.
        """
        self._instance.SetExtractScalars(scalars)

    def extract_contour_segments(self):
        """
        Extract contours for the previously set elevations.
        Returns:
            out_data: A map containing the scalar value as the key and the
                      contours for that value as the value.
        """
        return self._instance.ExtractContourSegments()

    def get_longest_contour_segments(self):
        """
        Gets the longest contour segments given a map of contours.
        Returns:
            A map containing the longest contours for each value (the value is the key)
        """
        return self._instance.GetLongestContourSegments()

    def get_intersecting_contour_lines(self, poly_line):
        """
        Get contour lines and contour values that intersect the given polyline.
        Args:
            poly_line: A polyline (centerline) to determine which contours intersect.
        Returns:
            A map containing the contour lines for each value (the value is the key).
        """
        return self._instance.GetIntersectingContourLines(poly_line)

    def get_connected_contour_lines(self):
        """
        Get connected contour lines and contour values that intersect the given polyline.
        Returns:
            A map containing the contour lines for each value (the value is the key).
        """
        return self._instance.GetConnectedContourLines()

    def set_contour_length_threshold(self, threshold):
        """
        Set threshold length for deleting unwanted contour segments.
        Args:
            threshold: The threshold length for deleting unwanted contour segments.
        """
        self._instance.SetContourLengthThreshold(threshold)

    def set_no_data_value(self, nodata_value):
        """
        Set value to use when extracted value is in inactive cell or doesn't intersect with the grid.
        Args:
            nodata_value: The no data value.
        """
        self._instance.SetNoDataValue(nodata_value)
