"""Entry points for the xmsbridge package."""

__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
import argparse
import sys

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.coverage.file_io.spectral_h5_converter import convert_spectral_h5_file

SMS_CONVERT_SPECTRAL_H5_COMMAND = 'convert_spectral_h5'


def main(arg_str=None):
    """The main routine.

    Args:
        arg_str (list): list of arguments for testing

    Returns:
        (int): return code
    """
    arguments = argparse.ArgumentParser(description='xmscoverage entry points')
    arguments.add_argument(dest='command', type=str, help='script to run')
    arguments.add_argument(dest='vars', nargs='*', help='other arguments')
    parsed_args = arguments.parse_args(arg_str)
    if parsed_args.command == SMS_CONVERT_SPECTRAL_H5_COMMAND:
        return convert_spectral_h5_file(arg_str)


if __name__ == "__main__":  # pragma: no cover
    sys.exit(main())
