"""SMS entry point for the simulation import script."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv

# 4. Local modules
from xms.cstorm.feedback.simulation_import_runner import import_simulation_with_feedback

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"


def main():
    """Entry point wrapper."""
    try:
        import_simulation_with_feedback()
    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":  # pragma: no cover
    main()
