"""Python wrapping for xms._data_objects.parameters.Simulation."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.data_objects._data_objects.parameters import Simulation as CSimulation


class Simulation:
    """The pure Python wrapper for C++ exposed xms._data_objects.parameters.Simulation objects."""
    def __init__(self, name=None, model=None, sim_uuid=None, instance=None):
        """Construct the wrapper.

        Args:
            name (str): Tree item name of the simulation
            model (str): XML-defined model name of the simulation
            sim_uuid (str): UUID of the simulation
            instance (CSimulation): The C++ Simulation object to wrap
        """
        if instance is None:
            self._instance = CSimulation()
        else:
            self._instance = instance

        if name is not None:
            self._instance.SetSimulationName(name)
        if model is not None:
            self._instance.SetModelName(model)
        if sim_uuid is not None:
            self._instance.SetUUID(sim_uuid)

    @property
    def name(self):
        """Returns the simulation's name."""
        return self._instance.GetSimulationName()

    @name.setter
    def name(self, sim_name):
        """Sets the simulation's name.

        Args:
            sim_name (str): name of the simulation
        """
        self._instance.SetSimulationName(sim_name)

    @property
    def uuid(self):
        """Returns the simulation's UUID."""
        return self._instance.GetUUID()

    @uuid.setter
    def uuid(self, sim_uuid):
        """Sets the simulation's UUID.

        Args:
            sim_uuid (str): UUID of the simulation
        """
        self._instance.SetUUID(sim_uuid)

    @property
    def model(self):
        """Returns the simulation's model name."""
        return self._instance.GetModelName()

    @model.setter
    def model(self, model_name):
        """Sets the simulation's model name.

        Args:
            model_name (str): name of the simulation's model
        """
        self._instance.SetModelName(model_name)
