"""Add preview widget."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import (QCheckBox, QHBoxLayout, QLabel, QLineEdit, QPushButton, QSizePolicy)

# 3. Aquaveo modules

# 4. Local modules


def add_preview_widget(widgets):
    """Preview widget for the EWN GUI."""
    widgets['plot_h_layout'] = QHBoxLayout()
    widgets['plot_v_layout'].addLayout(widgets['plot_h_layout'])
    widgets['btn_select_geom'] = QPushButton('Select UGrid/Mesh...')
    widgets['plot_h_layout'].addWidget(widgets['btn_select_geom'])
    widgets['txt_geom'] = QLabel('(none selected)')
    widgets['txt_geom_size_policy'] = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
    widgets['txt_geom'].setSizePolicy(widgets['txt_geom_size_policy'])
    widgets['plot_h_layout'].addWidget(widgets['txt_geom'])
    widgets['plot_h_layout'].addStretch()

    widgets['lock_h_layout'] = QHBoxLayout()
    widgets['plot_v_layout'].addLayout(widgets['lock_h_layout'])
    widgets['btn_select_lock_dataset'] = QPushButton('Select Lock Dataset...')
    widgets['btn_select_lock_dataset'].setEnabled(False)
    widgets['lock_h_layout'].addWidget(widgets['btn_select_lock_dataset'])
    widgets['txt_lock_dataset'] = QLabel('(none selected)')
    widgets['txt_lock_dataset'].setEnabled(False)
    widgets['txt_lock_dataset_size_policy'] = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
    widgets['txt_lock_dataset'].setSizePolicy(widgets['txt_lock_dataset_size_policy'])
    widgets['lock_h_layout'].addWidget(widgets['txt_lock_dataset'])
    widgets['lock_h_layout'].addStretch()

    widgets['h_layout_change_limit'] = QHBoxLayout()
    widgets['plot_v_layout'].addLayout(widgets['h_layout_change_limit'])
    widgets['txt_change_limit'] = QLabel('Element area change limit (fast 0.0 <--> 1.0 slow):')
    widgets['h_layout_change_limit'].addWidget(widgets['txt_change_limit'])
    widgets['edt_change_limit'] = QLineEdit('0.5')
    widgets['h_layout_change_limit'].addWidget(widgets['edt_change_limit'])
    widgets['h_layout_change_limit'].addStretch()

    widgets['h_layout_generate'] = QHBoxLayout()
    widgets['plot_v_layout'].addLayout(widgets['h_layout_generate'])
    widgets['btn_insert_feature'] = QPushButton('Generate mesh with feature...')
    widgets['h_layout_generate'].addWidget(widgets['btn_insert_feature'])
    widgets['tog_add_to_xms'] = QCheckBox('Add new mesh to SMS on exit')
    widgets['h_layout_generate'].addWidget(widgets['tog_add_to_xms'])
    widgets['tog_add_transition_cov_to_xms'] = QCheckBox('Add transition polygon to SMS on exit')
    widgets['h_layout_generate'].addWidget(widgets['tog_add_transition_cov_to_xms'])
    widgets['h_layout_generate'].addStretch()
