"""Wavemaker dict."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


"""
This module provides a dictionary of wave maker options.
"""

WAVE_MAKER_OPTIONS = {
    'INI_REC': 'Initial rectangular hump (INI_REC)',
    'INI_GAUS': 'Initial Gaussian hump (INI_GAUS)',
    'INI_SOL': 'Initial solitary wave propagation in +x direction (INI_SOL)',
    'LEF_SOL': 'Left boundary solitary (LEF_SOL)',
    'LEFT_BC_IRR': 'Wavemaker in the left boundary (LEFT_BC_IRR)',
    'TMA_1D': 'TMA 1D spectrum wavemaker (TMA_1D)',
    'JON_1D': 'JONSWAP 1D spectrum wavemaker (internal) (JON_1D)',
    'JON_2D': 'JONSWAP spectrum wavemaker (internal) (JON_2D)',
    'WK_REG': 'Wei and Kirby 1999 internal wave maker (WK_REG)',
    'WK_IRR': 'Wei and Kirby 1999 TMA spectrum wavemaker (internal) (WK_IRR)',
    'WK_NEW_IRR': 'Wei and Kirby directional wavemaker (WK_NEW_IRR)',
    'WK_TIME_SERIES': 'FFT of a time series (WK_TIME_SERIES) *Not Supported in SMS*',
    'WK_DATA2D': '2D directional spectrum data specified in WaveCompFile (WK_DATA2D) *Not Supported in SMS*',
    'WK_NEW_DATA2D': 'Wei and Kirby wave data (WK_NEW_DATA2D) *Not Supported in SMS*',
}
