"""This is a table widget for specifying bypass events."""

# 1. Standard Python modules
import datetime

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.models.rename_model import RenameModel

# 4. Local modules
from xms.gencade.gui.gencade_table_widget import GenCadeTableWidget


class PrintTableWidget(GenCadeTableWidget):
    """Table widget base class."""
    def __init__(self, parent, data_frame, fixed_size=False):
        """Construct the widget.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
            data_frame (:obj:`pandas.DataFrame`): The model data.
            fixed_size (:obj:`bool`): True if the table is a fixed size.
        """
        self.rename_model = None
        self.fixed_size = fixed_size

        # set the first column to datetime64
        data_frame[data_frame.columns[0]] = data_frame[data_frame.columns[0]].astype(dtype='datetime64[ns]')

        super().__init__(parent, data_frame, 0, {'print_date': datetime.date(2000, 1, 1)})

    def setup_ui(self):
        """Sets up the delegates, validators, and filter model for this table."""
        self.rename_model = RenameModel(['Print Date'], self)
        super()._setup_ui({}, False, False, self.rename_model)
