"""Type hint and enum for a dataset callback."""

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"

# 1. Standard Python modules
from enum import auto, Enum
from typing import Callable, TypeAlias

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.tree import TreeNode

# 4. Local modules
from xms.gmi.data.generic_model import Parameter


class DatasetRequest(Enum):
    """Enum representing why a `DatasetCallback` is being called."""
    GetLabel = auto()
    GetTree = auto()


#: Type alias for a callback for managing datasets.
#:
#: Args:
#:     mode: One of the modes from DatasetRequest.
#:     parameter: The parameter to manage a dataset for. If `mode` is `GetLabel`, then the value in `parameter` will
#:         be the UUID to get the label of.
#:
#: Returns:
#:
#:     - If mode is `GetLabel`, the label to identify the dataset by to the user.
#:     - If mode is `GetTree`, a project explorer tree filtered to contain only the datasets the user can choose.
DatasetCallback: TypeAlias = Callable[[DatasetRequest, Parameter], str | TreeNode]
