"""Writes the .smt stream mapping table file."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def write(gssha_file_path: Path) -> Path | None:
    """Writes the GSSHA_STREAM_INDEX_MAP_TABLES (.smt) file and returns the file path.

    Args:
        gssha_file_path (str | Path): .gssha file path.
    """
    # For now, we just stub out the file
    smt_file_path = gssha_file_path.with_suffix('.smt')
    with open(smt_file_path, 'w') as file:
        file.write('GSSHA_STREAM_INDEX_MAP_TABLES\n')
        file.write('ROUGHNESS ""\n')
        file.write('NUM_IDS 0\n')
        file.write(
            'ID    DESCRIPTION1                            DESCRIPTION2'
            '                                   ROUGH\n'
        )
    return smt_file_path
