"""Creates the generic model for the Observation coverage type."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel

# 4. Local modules


def create() -> GenericModel:
    """Creates and returns the generic model for the Observation coverage type.

    Returns:
        (GenericModel): The generic model.
    """
    gm = GenericModel(exclusive_point_conditions=True)

    # Descriptions
    desc = {
        'name': 'Descriptive name for the observation point, up to 40 characters.',
        'interpolate':
            'Output values are linearly interpolated from the nodal values at the vertices of the element '
            'that contains the observation point.'
    }

    # Points
    group = gm.point_parameters.add_group(group_name='Observation point', label='Observation point')
    group.add_text(name='name', label='Name', default='observation_point', description=desc['name'], required=True)
    group.add_boolean(name='interpolate', label='Interpolate', default=False, description=desc['interpolate'])
    return gm
