"""Entry point for the SMS simulation export script."""

# 1. Standard Python modules
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query, XmsEnvironment as XmEnv
from xms.guipy.dialogs.process_feedback_dlg import run_feedback_dialog

# 4. Local modules
from xms.hydroas.dmi.xms_data import XmsData
from xms.hydroas.feedback.export_sim_runner import ExportSimRunner


def main(query: Optional[Query] = None):  # pragma: no cover
    """Entry point wrapper."""
    try:
        data = XmsData(query or Query())
        worker = ExportSimRunner(data)
        run_feedback_dialog(worker)

    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":  # pragma: no cover
    main()
