"""API for xmsmesher."""
from xms import grid

from xms.mesher.meshing import mesh_utils
from xms.mesher.meshing import MultiPolyMesherIo


def generate_mesh(polygon_inputs, refine_points=None, **kwargs):
    """Generate a mesh from input polygons.

    Args:
        polygon_inputs (PolyInput): The polygon inputs for meshing
        refine_points (list): A list of RefinePoint's used in meshing

    Returns:
        A UGrid generated by the meshing process.

    Raises:
        A runtime error if meshing was unsuccessful.
    """
    if refine_points is None:
        refine_points = []

    mesher = MultiPolyMesherIo(polygons=polygon_inputs, refine_points=refine_points, **kwargs)

    success, error = mesh_utils.generate_mesh(mesher)
    if not success:
        raise RuntimeError(error)

    return grid.ugrid.UGrid(points=mesher.points, cellstream=mesher.cells)
